Option Strict Off
Option Explicit On
Module SamplePrint
	
	'*************************************************************
	' WIN32֘A
	'*************************************************************
	
	' ******************************************************
	' APIp
	' ******************************************************

    Declare Function CreateDC Lib "gdi32.dll" Alias "CreateDCA" (ByVal lpszDriver As String, ByVal lpszDevice As String, ByVal lpszOutput As Integer, ByVal lpInitData As IntPtr) As Integer
    Declare Function DeleteDC Lib "gdi32.dll" (ByVal hdc As Integer) As Integer

    Structure DOCINFO
        Dim cbSize As Integer
        Dim lpszDocName As String
        Dim lpszOutput As String
    End Structure

    Declare Function StartDoc Lib "gdi32" Alias "StartDocA" (ByVal hdc As Integer, ByRef lpdi As DOCINFO) As Integer
    Declare Function StartPage Lib "gdi32" (ByVal hdc As Integer) As Integer
    Declare Function EndPage Lib "gdi32" (ByVal hdc As Integer) As Integer
    Declare Function EndDoc Lib "gdi32" (ByVal hdc As Integer) As Integer
    Declare Function AbortDoc Lib "gdi32" (ByVal hdc As Integer) As Integer

    ' ******************************************************
    ' f[^o͗p
    ' ******************************************************
    Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Integer, ByVal x As Integer, ByVal y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer
    Public Const DT_TOP As Short = &H0S
    Public Const DT_LEFT As Short = &H0S
    Public Const DT_CENTER As Short = &H1S
    Public Const DT_RIGHT As Short = &H2S
    Public Const DT_VCENTER As Short = &H4S
    Public Const DT_BOTTOM As Short = &H8S
    Public Const DT_WORDBREAK As Short = &H10S
    Public Const DT_SINGLELINE As Short = &H20S
    Public Const DT_EXPANDTABS As Short = &H40S
    Public Const DT_TABSTOP As Short = &H80S
    Public Const DT_NOCLIP As Short = &H100S
    Public Const DT_EXTERNALLEADING As Short = &H200S
    Public Const DT_CALCRECT As Short = &H400S
    Public Const DT_NOPREFIX As Short = &H800S
    Public Const DT_INTERNAL As Short = &H1000S

    Declare Function DrawText Lib "user32" Alias "DrawTextA" (ByVal hdc As Integer, ByVal lpStr As String, ByVal nCount As Integer, ByRef lpRect As RECT, ByVal wFormat As Integer) As Integer

    ' ******************************************************
    ' p
    ' ******************************************************
    Structure POINTAPI
        Dim x As Integer
        Dim y As Integer
    End Structure

    'Declare Function MoveToEx Lib "gdi32" ( _
    ''    ByVal hDc As Long, _
    ''    ByVal x As Long, _
    ''    ByVal y As Long, _
    ''    lpPoint As POINTAPI _
    '') As Long
    Declare Function MoveToEx Lib "gdi32" (ByVal hdc As Integer, ByVal x As Integer, ByVal y As Integer, ByVal pLastPoint As Integer) As Integer

    Declare Function LineTo Lib "gdi32" (ByVal hdc As Integer, ByVal x As Integer, ByVal y As Integer) As Integer

    ' ******************************************************
    ' Fhp
    ' ******************************************************
    Structure RECT
        Dim Left_Renamed As Integer
        Dim Top As Integer
        Dim Right_Renamed As Integer
        Dim Bottom As Integer
    End Structure
    Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Integer) As Integer
    Declare Function SelectObject Lib "gdi32" (ByVal hdc As Integer, ByVal hObject As Integer) As Integer
    Declare Function FillRect Lib "user32" (ByVal hdc As Integer, ByRef lpRect As RECT, ByVal hBrush As Integer) As Integer
    Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Integer) As Integer


    ' ******************************************************
    ' foCX擾
    ' ******************************************************
    Declare Function GetDeviceCaps Lib "gdi32" (ByVal hdc As Integer, ByVal nIndex As Integer) As Integer

    Public Const PHYSICALWIDTH As Short = 110 '  Physical Width in device units
    Public Const PHYSICALHEIGHT As Short = 111 '  Physical Height in device units
    Public Const PHYSICALOFFSETX As Short = 112 '  Physical Printable Area x margin
    Public Const PHYSICALOFFSETY As Short = 113 '  Physical Printable Area y margin
    Public Const SCALINGFACTORX As Short = 114 '  Scaling factor x
    Public Const SCALINGFACTORY As Short = 115 '  Scaling factor y

    Structure TEXTMETRIC
        Dim tmHeight As Integer
        Dim tmAscent As Integer
        Dim tmDescent As Integer
        Dim tmInternalLeading As Integer
        Dim tmExternalLeading As Integer
        Dim tmAveCharWidth As Integer
        Dim tmMaxCharWidth As Integer
        Dim tmWeight As Integer
        Dim tmOverhang As Integer
        Dim tmDigitizedAspectX As Integer
        Dim tmDigitizedAspectY As Integer
        Dim tmFirstChar As Byte
        Dim tmLastChar As Byte
        Dim tmDefaultChar As Byte
        Dim tmBreakChar As Byte
        Dim tmItalic As Byte
        Dim tmUnderlined As Byte
        Dim tmStruckOut As Byte
        Dim tmPitchAndFamily As Byte
        Dim tmCharSet As Byte
    End Structure
    Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" (ByVal hdc As Integer, ByRef lpMetrics As TEXTMETRIC) As Integer

    ' ******************************************************
    ' tHg
    ' ******************************************************
    'used with fnWeight
    Const FW_DONTCARE As Short = 0
    Const FW_THIN As Short = 100
    Const FW_EXTRALIGHT As Short = 200
    Const FW_LIGHT As Short = 300
    Const FW_NORMAL As Short = 400
    Const FW_MEDIUM As Short = 500
    Const FW_SEMIBOLD As Short = 600
    Const FW_BOLD As Short = 700
    Const FW_EXTRABOLD As Short = 800
    Const FW_HEAVY As Short = 900
    Const FW_BLACK As Short = FW_HEAVY
    Const FW_DEMIBOLD As Short = FW_SEMIBOLD
    Const FW_REGULAR As Short = FW_NORMAL
    Const FW_ULTRABOLD As Short = FW_EXTRABOLD
    Const FW_ULTRALIGHT As Short = FW_EXTRALIGHT

    'used with fdwCharSet
    Const ANSI_CHARSET As Short = 0
    Const DEFAULT_CHARSET As Short = 1
    Const SYMBOL_CHARSET As Short = 2
    Const SHIFTJIS_CHARSET As Short = 128
    Const HANGEUL_CHARSET As Short = 129
    Const CHINESEBIG5_CHARSET As Short = 136
    Const OEM_CHARSET As Short = 255

    'used with fdwOutputPrecision
    Const OUT_CHARACTER_PRECIS As Short = 2
    Const OUT_DEFAULT_PRECIS As Short = 0
    Const OUT_DEVICE_PRECIS As Short = 5
    'used with fdwClipPrecision
    Const CLIP_DEFAULT_PRECIS As Short = 0
    Const CLIP_CHARACTER_PRECIS As Short = 1
    Const CLIP_STROKE_PRECIS As Short = 2
    'used with fdwQuality
    Const DEFAULT_QUALITY As Short = 0
    Const DRAFT_QUALITY As Short = 1
    Const PROOF_QUALITY As Short = 2

    ' Pitch and family constants.
    Public Const DEFAULT_PITCH As Short = 0
    Public Const FIXED_PITCH As Short = 1
    Public Const VARIABLE_PITCH As Short = 2
    Public Const TRUETYPE_FONTTYPE As Short = &H4S
    Public Const FF_DECORATIVE As Short = 80 '  Old English, etc.
    Public Const FF_DONTCARE As Short = 0 '  Don't care or don't know.
    Public Const FF_MODERN As Short = 48 '  Constant stroke width, serifed or sans-serifed.
    Public Const FF_ROMAN As Short = 16 '  Variable stroke width, serifed.
    Public Const FF_SCRIPT As Short = 64 '  Cursive, etc.
    Public Const FF_SWISS As Short = 32 '  Variable stroke width, sans-serifed.

    'used with SetBkMode
    Const OPAQUE As Short = 2
    Const TRANSPARENT As Short = 1

    Declare Function CreateFont Lib "gdi32" Alias "CreateFontA" (ByVal H As Integer, ByVal W As Integer, ByVal E As Integer, ByVal O As Integer, ByVal W As Integer, ByVal i As Integer, ByVal u As Integer, ByVal S As Integer, ByVal C As Integer, ByVal OP As Integer, ByVal CP As Integer, ByVal Q As Integer, ByVal PAF As Integer, ByVal F As String) As Integer
    Public Const LOGPIXELSX As Short = 88 '  Logical pixels/inch in X
    Public Const LOGPIXELSY As Short = 90 '  Logical pixels/inch in Y
    Declare Function MulDiv Lib "kernel32" (ByVal nNumber As Integer, ByVal nNumerator As Integer, ByVal nDenominator As Integer) As Integer

    ' ******************************************************
    ' y
    ' ******************************************************
    'fnPenStyle̒萔
    Private Const PS_SOLID As Short = 0 '
    Private Const PS_DASH As Short = 1 'j
    Private Const PS_DOT As Short = 2 '_
    Private Const PS_DASHDOT As Short = 3 '_
    Private Const PS_DASHDOTDOT As Short = 4 '_
    Private Const PS_NULL As Short = 5 '\
    Private Const PS_INSIDEFRAME As Short = 6 'hԂ

    Declare Function CreatePen Lib "gdi32.dll" (ByVal fnPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Integer) As Integer

    '*************************************************************
    ' 萔`
    '*************************************************************

    Const SFCSPRT_PRINTERNAME As String = "MEGASOFT STARFAX 15" ' STARFAX v^hCo

    '*************************************************************
    ' ϐ`
    '*************************************************************

    '*************************************************************
    ' v^hCoDC擾
    '*************************************************************

    Function PRN_GetSFCSPrinterDc() As Integer

        PRN_GetSFCSPrinterDc = CreateDC("", SFCSPRT_PRINTERNAME, 0, IntPtr.Zero)

    End Function


    '*************************************************************
    ' v^hCoDC폜
    '*************************************************************

    Sub PRN_DelSFCSPrinterDc(ByRef hdc As Integer)

        Call DeleteDC(hdc)

    End Sub

    '*************************************************************
    ' Tv
    '*************************************************************
    Sub PROC_SamplePrint(ByRef strText As String)

        Dim hdc As Integer
        Dim hFontOld As Integer
        Dim hDate As Integer
        Dim hTitle As Integer
        Dim hGreeting As Integer
        Dim hText As Integer
        Dim hPenTitle As Integer
        Dim hPenText As Integer
        Dim hOldPen As Integer

        Dim rectDate As RECT
        Dim rectTitle As RECT
        Dim rectGreeting As RECT
        Dim rectText As RECT

        Dim strDate As String

        Dim di As DOCINFO

        hdc = PRN_GetSFCSPrinterDc()
        If hdc = 0 Then
            Exit Sub
        End If

        hDate = 0
        hTitle = 0
        hGreeting = 0
        hText = 0

        di.cbSize = 12
        di.lpszDocName = "PrtSample"

        If StartDoc(hdc, di) <= 0 Then
            PRN_DelSFCSPrinterDc((hdc))
            Exit Sub
        End If

        If StartPage(hdc) <= 0 Then
            AbortDoc(hdc)
            PRN_DelSFCSPrinterDc((hdc))
            Exit Sub
        End If

        '-------------------------------------------------------------
        ' tHg쐬
        hDate = CreateFont(-24, 0, 0, 0, FW_SEMIBOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
        hTitle = CreateFont(-72, 0, 0, 0, FW_BOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
        hGreeting = CreateFont(-48, 0, 0, 0, FW_SEMIBOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
        hText = CreateFont(-36, 0, 0, 0, FW_DONTCARE, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")

        '-------------------------------------------------------------
        ' y쐬
        hPenTitle = CreatePen(PS_SOLID, 8, RGB(0, 0, 0))
        hPenText = CreatePen(PS_SOLID, 4, RGB(0, 0, 0))

        '-------------------------------------------------------------
        ' Wݒ
        rectDate.Top = 50
        rectDate.Bottom = 80
        rectDate.Left_Renamed = 1010
        rectDate.Right_Renamed = 1510
        rectTitle.Top = 90
        rectTitle.Bottom = 190
        rectTitle.Left_Renamed = 10
        rectTitle.Right_Renamed = 1510
        rectGreeting.Top = 200
        rectGreeting.Bottom = 400
        rectGreeting.Left_Renamed = 20
        rectGreeting.Right_Renamed = 1500
        rectText.Top = 410
        rectText.Bottom = 1210
        rectText.Left_Renamed = 30
        rectText.Right_Renamed = 1490

        '-------------------------------------------------------------
        ' t
        strDate = Microsoft.VisualBasic.Format(Now, "yyyy") & "N" & Microsoft.VisualBasic.Format(Now, "mm") & "" & Microsoft.VisualBasic.Format(Now, "dd") & ""
        hFontOld = SelectObject(hdc, hDate)

        Call DrawText(hdc, strDate, -1, rectDate, DT_NOPREFIX Or DT_WORDBREAK Or DT_RIGHT Or DT_SINGLELINE)

        '-------------------------------------------------------------
        ' ^Cg

        Call SelectObject(hdc, hTitle)

        Call DrawText(hdc, "e`we", 10, rectTitle, DT_NOPREFIX Or DT_WORDBREAK Or DT_CENTER Or DT_VCENTER Or DT_SINGLELINE)

        hOldPen = SelectObject(hdc, hPenTitle)
        Call MoveToEx(hdc, rectTitle.Left_Renamed, rectTitle.Top, 0)
        Call LineTo(hdc, rectTitle.Right_Renamed, rectTitle.Top)
        Call MoveToEx(hdc, rectTitle.Left_Renamed, rectTitle.Bottom, 0)
        Call LineTo(hdc, rectTitle.Right_Renamed, rectTitle.Bottom)

        '-------------------------------------------------------------
        ' A
        Call SelectObject(hdc, hGreeting)

        Call DrawText(hdc, "STARFAXAɂ肪Ƃ܂B", 51, rectGreeting, DT_NOPREFIX Or DT_WORDBREAK Or DT_CENTER Or DT_VCENTER Or DT_SINGLELINE)

        '-------------------------------------------------------------
        ' {
        Call SelectObject(hdc, hPenText)
        Call MoveToEx(hdc, rectText.Left_Renamed, rectText.Top, 0)
        Call LineTo(hdc, rectText.Right_Renamed, rectText.Top)
        Call LineTo(hdc, rectText.Right_Renamed, rectText.Bottom)
        Call LineTo(hdc, rectText.Left_Renamed, rectText.Bottom)
        Call LineTo(hdc, rectText.Left_Renamed, rectText.Top)
        rectText.Top = rectText.Top + 20
        rectText.Bottom = rectText.Bottom - 20
        rectText.Left_Renamed = rectText.Left_Renamed + 20
        rectText.Right_Renamed = rectText.Right_Renamed - 20
        Call SelectObject(hdc, hText)

        Call DrawText(hdc, strText, -1, rectText, DT_NOPREFIX Or DT_WORDBREAK)

        Call SelectObject(hdc, hFontOld)
        DeleteObject(hDate)
        DeleteObject(hTitle)
        DeleteObject(hGreeting)
        DeleteObject(hText)

        Call SelectObject(hdc, hOldPen)
        DeleteObject(hPenTitle)
        DeleteObject(hPenText)

        EndPage(hdc)
        EndDoc(hdc)

        PRN_DelSFCSPrinterDc((hdc))

    End Sub
End Module